Trosk.grid.Trosk = function(config) {
    config = config || {};
    Ext.applyIf(config,{
        id: 'trosk-grid-trosk'
        ,url: Trosk.config.connectorUrl
        ,baseParams: { action: 'mgr/trosk/getList' }
        ,fields: ['id','name','values','type','menu']
        ,paging: true
        ,remoteSort: true
        ,anchor: '97%'
        ,autoExpandColumn: 'name'
        ,save_action: 'mgr/trosk/updateFromGrid'
        ,autosave: true        	
        ,columns: [{
            header: _('id')
            ,dataIndex: 'id'
            ,sortable: true
            ,width: 60
        },{
            header: _('trosk.name')
            ,dataIndex: 'name'
            ,sortable: true
            ,width: 100
            ,editor: { xtype: 'textfield' }
        },{
            header: _('trosk.description')
            ,dataIndex: 'values'
            ,sortable: false
            ,width: 350
            ,editor: { xtype: 'textfield' }
        },{
            header: _('trosk.tip')
            ,dataIndex: 'type'
            ,sortable: true
            ,width: 50
            ,editor: { xtype: 'textfield' }
        }]
        ,tbar:[{
            xtype: 'textfield'
            ,id: 'trosk-search-filter'
            ,emptyText: _('trosk.search...')
            ,listeners: {
                'change': {fn:this.search,scope:this}
                ,'render': {fn: function(cmp) {
                    new Ext.KeyMap(cmp.getEl(), {
                        key: Ext.EventObject.ENTER
                        ,fn: function() {
                            this.fireEvent('change',this);
                            this.blur();
                            return true;
                        }
                        ,scope: cmp
                    });
                },scope:this}
            }
        }
        ,{
        	text: _('trosk.parametar_create')
        	,handler: { xtype: 'trosk-window-trosk-create' ,blankValues: true }
        }]
        ,getMenu: function() {
            var m = [{
                text: _('trosk.parametar_update')
                ,handler: this.updateTrosk
            },'-',{
                text: _('trosk.parametar_remove')
                ,handler: this.removeTrosk
            }];
            this.addContextMenuItem(m);
            return true;
        }
        ,updateTrosk: function(btn,e) {
            if (!this.updateTroskWindow) {
                this.updateTroskWindow = MODx.load({
                    xtype: 'trosk-window-trosk-update'
                    ,record: this.menu.record
                    ,listeners: {
                        'success': {fn:this.refresh,scope:this}
                    }
                });
            } else {
                this.updateTroskWindow.setValues(this.menu.record);
            }
            this.updateTroskWindow.show(e.target);
        }
        ,removeTrosk: function() {
            MODx.msg.confirm({
                title: _('trosk.parametar_remove')
                ,text: _('trosk.parametar_remove_confirm')
                ,url: this.config.url
                ,params: {
                    action: 'mgr/trosk/remove'
                    ,id: this.menu.record.id
                }
                ,listeners: {
                    'success': {fn:this.refresh,scope:this}
                }
            });
        }
    });
    Trosk.grid.Trosk.superclass.constructor.call(this,config)
};
Ext.extend(Trosk.grid.Trosk,MODx.grid.Grid,{
    search: function(tf,nv,ov) {
        var s = this.getStore();
        s.baseParams.query = tf.getValue();
        this.getBottomToolbar().changePage(1);
        this.refresh();
    }
});
Ext.reg('trosk-grid-trosk',Trosk.grid.Trosk);

Trosk.window.UpdateTrosk = function(config) {
    config = config || {};
    Ext.applyIf(config,{
        title: _('trosk.parametar_update')
        ,url: Trosk.config.connectorUrl
        ,baseParams: {
            action: 'mgr/trosk/update'
        }
        ,fields: [{
            xtype: 'hidden'
            ,name: 'id'
        },{
            xtype: 'textfield'
            ,fieldLabel: _('trosk.name')
            ,name: 'name'
            ,width: 300
        },{
            xtype: 'textarea'
            ,fieldLabel: _('trosk.description')
            ,name: 'values'
            ,width: 300
        },{
            xtype: "radiogroup",
            fieldLabel: _('trosk.tip'),
            name: "type",
            defaults: {xtype: "radio",name: "type"},
            items: [
                {
                    boxLabel: _('trosk.tip1'),
                    inputValue: "1",
                },
                {
                    boxLabel: _('trosk.tip2'),
                    inputValue: "2",
                }
            ]
        }]
    });
    Trosk.window.UpdateTrosk.superclass.constructor.call(this,config);
};
Ext.extend(Trosk.window.UpdateTrosk,MODx.Window);
Ext.reg('trosk-window-trosk-update',Trosk.window.UpdateTrosk);

Trosk.window.CreateTrosk = function(config) {
    config = config || {};
    Ext.applyIf(config,{
        title: _('trosk.parametar_create')
        ,url: Trosk.config.connectorUrl
        ,baseParams: {
            action: 'mgr/trosk/create'
        }
        ,fields: [{
            xtype: 'textfield'
            ,fieldLabel: _('trosk.name')
            ,name: 'name'
            ,width: 300
        },{
            xtype: 'textarea'
            ,fieldLabel: _('trosk.description')
            ,name: 'values'
            ,width: 300
        },{
            xtype: "radiogroup",
            fieldLabel: _('trosk.tip'),
            name: "type",
            defaults: {xtype: "radio",name: "type"},
            items: [
                {
                    boxLabel: _('trosk.tip1'),
                    inputValue: "1",
                },
                {
                    boxLabel: _('trosk.tip2'),
                    inputValue: "2",
                }
            ]
        }]
    });
    Trosk.window.CreateTrosk.superclass.constructor.call(this,config);
};
Ext.extend(Trosk.window.CreateTrosk,MODx.Window);
Ext.reg('trosk-window-trosk-create',Trosk.window.CreateTrosk);