<?php
$trosk = $modx->getService('trosk','Trosk',$modx->getOption('doodles.core_path',null,$modx->getOption('core_path').'components/trosk/').'model/trosk/',$scriptProperties);
if (!($trosk instanceof Trosk)) return '';

$toPdf=$_REQUEST['topdf'];
if(empty($toPdf)) return '';

$projectId=$_REQUEST['proj_id'];

if(empty($projectId)) return 'wwww';

$render=$trosk->renderTrosk($projectId,'pdf');
$output=$render['output'];
$toc=$render['toc'];
foreach ($toc as $value) {
	$sadrzaj.=$value.'<br>';
}

require_once($modx->getOption('core_path').'components/tcpdf/config/lang/hrv.php');
require_once($modx->getOption('core_path').'components/tcpdf/tcpdf.php');

class MYPDF extends TCPDF {
	public $modx;
	public $projectId;
    public function __construct(modX &$modx,$projectId) { 
        parent::__construct(PDF_PAGE_ORIENTATION, PDF_UNIT, PDF_PAGE_FORMAT, true, 'UTF-8', false); 
        $this->modx=& $modx;
        $this->projectId=$projectId;
    }
    //Page header
    public function Header() {
        // Logo
        //$image_file = $this->modx->getOption('assets_path').'images/logo.jpg';
        //$this->Image($image_file, 5, 5, 15, 11, 'JPG', '', 'T', false, 300, '', false, false, 0, false, false, false);
        // Set font
        $this->SetFont('dejavusans', '', 9,'','false');
        // Title
        $this->Cell(0, 15, 'http://troskovnik.hr', 0, false, 'L', 0, '', 0, false, 'M', 'M');
        $this->Cell(0, 15, 'projekt: '.$this->modx->trosk->getTroskName($this->projectId), 0, false, 'R', 0, '', 0, false, 'M', 'M');
    }

}


// create new PDF document
$pdf = new MYPDF($modx,$projectId);

// set document information
$pdf->SetCreator('troskovnik.hr');
$pdf->SetAuthor('troskovnik.hr');
$pdf->SetTitle('troskovnik.hr');
$pdf->SetSubject('troskovnik.hr');
$pdf->SetKeywords('Generirao: troskovnik.hr');

// set default header data
$pdf->SetHeaderData(PDF_HEADER_LOGO, PDF_HEADER_LOGO_WIDTH, PDF_HEADER_TITLE.' 061', PDF_HEADER_STRING);

// set header and footer fonts
$pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
$pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));

// set default monospaced font
$pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);

//set margins
$pdf->SetMargins(PDF_MARGIN_LEFT, PDF_MARGIN_TOP, PDF_MARGIN_RIGHT);
$pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
$pdf->SetFooterMargin(PDF_MARGIN_FOOTER);

//set auto page breaks
$pdf->SetAutoPageBreak(TRUE, PDF_MARGIN_BOTTOM);

//set image scale factor
$pdf->setImageScale(PDF_IMAGE_SCALE_RATIO);

//set some language-dependent strings
$pdf->setLanguageArray($l);

// ---------------------------------------------------------

// set font
//$pdf->SetFont('helvetica', '', 10);
$pdf->SetFont('dejavusans', '', 17,'','false');


// add a page
$pdf->AddPage();

/* NOTE:
 * *********************************************************
 * You can load external XHTML using :
 *
 * $html = file_get_contents('/path/to/your/file.html');
 *
 * External CSS files will be automatically loaded.
 * Sometimes you need to fix the path of the external CSS.
 * *********************************************************
 */
$imeTrosk=$pdf->modx->trosk->getTroskName($pdf->projectId);
$pdf->MultiCell(0, 0, 'projekt:'.$imeTrosk, 0, 'C', 0, 1, '', 100, true, 0);

$pdf->SetFont('dejavusans', '', 9,'','false');

// add a page
$pdf->AddPage();

// define some HTML content with style
$html = <<<EOF
Sadrzaj:<br><br>
$sadrzaj
EOF;

// output the HTML content

$pdf->writeHTML($html, true, false, true, false, '');

// add a page
$pdf->AddPage();

// define some HTML content with style
$html = <<<EOF
$output
EOF;

// output the HTML content
$pdf->writeHTML($html, true, false, true, false, '');


// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

// *******************************************************************
// HTML TIPS & TRICKS
// *******************************************************************

// REMOVE CELL PADDING
//
// $pdf->SetCellPadding(0);
// 
// This is used to remove any additional vertical space inside a 
// single cell of text.

// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

// REMOVE TAG TOP AND BOTTOM MARGINS
//
// $tagvs = array('p' => array(0 => array('h' => 0, 'n' => 0), 1 => array('h' => 0, 'n' => 0)));
// $pdf->setHtmlVSpace($tagvs);
// 
// Since the CSS margin command is not yet implemented on TCPDF, you
// need to set the spacing of block tags using the following method.

// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

// SET LINE HEIGHT
//
// $pdf->setCellHeightRatio(1.25);
// 
// You can use the following method to fine tune the line height
// (the number is a percentage relative to font height).

// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

// CHANGE THE PIXEL CONVERSION RATIO
//
// $pdf->setImageScale(0.47);
// 
// This is used to adjust the conversion ratio between pixels and 
// document units. Increase the value to get smaller objects.
// Since you are using pixel unit, this method is important to set the
// right zoom factor.
// 
// Suppose that you want to print a web page larger 1024 pixels to 
// fill all the available page width.
// An A4 page is larger 210mm equivalent to 8.268 inches, if you 
// subtract 13mm (0.512") of margins for each side, the remaining 
// space is 184mm (7.244 inches).
// The default resolution for a PDF document is 300 DPI (dots per 
// inch), so you have 7.244 * 300 = 2173.2 dots (this is the maximum 
// number of points you can print at 300 DPI for the given width).
// The conversion ratio is approximatively 1024 / 2173.2 = 0.47 px/dots
// If the web page is larger 1280 pixels, on the same A4 page the 
// conversion ratio to use is 1280 / 2173.2 = 0.59 pixels/dots

// *******************************************************************

// reset pointer to the last page
$pdf->lastPage();

// ---------------------------------------------------------

//Close and output PDF document
$pdf->Output('troskovnik.hr.pdf', 'D');

//============================================================+
// END OF FILE                                                
//============================================================+